# This script builds the trade data set based on data downloaded from Tick History

# Set working directory
setwd("D:/");

# Loading function
source("code/fakeData_function.R")

# Required packages
require(data.table);   # The script uses data.table, which is much faster than data.frames. 

# Generate 10 stocks, 10 days
tq = mapply(fakeData_function, ticker = LETTERS[seq( from = 1, to = 10 )], P = seq(10,100,10), S = seq(0.1,1,0.1), SIMPLIFY = F);
tq = do.call(rbind,tq);

# Add Tick History variables used in the paper
tq$Seq.No. = 1:nrow(tq);
tq$Seq.No.[tq$Type == "Quote"] = NA;
tq$Qualifiers = "";
tq$BuyerID = "";
tq$SellerID = "";
tq$tickDir = "";
tq$gmtOffset = 0;
tq$Exch.Time = "";
tq$Quote.Time = "";

# Generating time stamps conforming to the Tick History format
hours = trunc(tq$Time/3600);
minutes = trunc((tq$Time - hours*3600)/60);
seconds = tq$Time - hours*3600 - minutes*60;
tq$Time = paste(hours+5,formatC(minutes,width=2,flag="0"),formatC(round(seconds,3),width=6,flag="0"),sep=":");
tq$Exch.Time[tq$Type == "Trade"] = tq$Time[tq$Type == "Trade"];
tq$Quote.Time[tq$Type == "Trade"] = "";
tq$Quote.Time[tq$Type == "Quote"] = tq$Time[tq$Type == "Quote"];
rm(hours,minutes,seconds);

# Saving the data
save(list = "tq", file = "input/pseudodata");
