# This script runs the analyses underlying Section 6 in the paper

# Set working directory
setwd("D:/");

# Loading functions and trade data
source("code/effSpread_functions.R");
load("temp/pseudotrades");

# Required packages
require(data.table);   # The script uses data.table, which is much faster than data.frames. 

###########################################
# TABLE 5: EFFECTIVE SPREAD DECOMPOSITION #
###########################################

# Spread decomposition
sprDecomp_5mn = round(rbind(weighted.means.2var(dt=tt, var1 = "pi5mn_wmd", var2 = "pi5mn_mid", weight.var = "USDvol", subset = !is.na(tt$mid5min) & !is.na(tt$mic5min), cluster = c("Stock", "Date", "Venue")),
                            weighted.means.2var(dt=tt, var1 = "pi5mn_mic", var2 = "pi5mn_mid", weight.var = "USDvol", subset = !is.na(tt$mid5min) & !is.na(tt$mic5min), cluster = c("Stock", "Date", "Venue")),
                            weighted.means.2var(dt=tt, var1 = "rs5mn_wmd", var2 = "rs5mn_mid", weight.var = "USDvol", subset = !is.na(tt$mid5min) & !is.na(tt$mic5min), cluster = c("Stock", "Date", "Venue")),
                            weighted.means.2var(dt=tt, var1 = "rs5mn_mic", var2 = "rs5mn_mid", weight.var = "USDvol", subset = !is.na(tt$mid5min) & !is.na(tt$mic5min), cluster = c("Stock", "Date", "Venue"))),4);
dimnames(sprDecomp_5mn) = list(c("PimpWmd_5mn","PimpMic_5mn","RsprWmd_5mn","RsprMic_5mn"),
                               c("v","mid","NomBias","RelBias","t","p"));

sprDecomp_10s = round(rbind(weighted.means.2var(dt=tt, var1 = "pi10s_wmd", var2 = "pi10s_mid", weight.var = "USDvol", subset = !is.na(tt$mid10s) & !is.na(tt$mic10s), cluster = c("Stock", "Date", "Venue")),
                            weighted.means.2var(dt=tt, var1 = "pi10s_mic", var2 = "pi10s_mid", weight.var = "USDvol", subset = !is.na(tt$mid10s) & !is.na(tt$mic10s), cluster = c("Stock", "Date", "Venue")),
                            weighted.means.2var(dt=tt, var1 = "rs10s_wmd", var2 = "rs10s_mid", weight.var = "USDvol", subset = !is.na(tt$mid10s) & !is.na(tt$mic10s), cluster = c("Stock", "Date", "Venue")),
                            weighted.means.2var(dt=tt, var1 = "rs10s_mic", var2 = "rs10s_mid", weight.var = "USDvol", subset = !is.na(tt$mid10s) & !is.na(tt$mic10s), cluster = c("Stock", "Date", "Venue"))),4);
dimnames(sprDecomp_10s) = list(c("PimpWmd_10s", "PimpMic_10s", "RsprWmd_10s", "RsprMic_10s"),
                               c("v", "mid", "NomBias", "RelBias", "t", "p"));

# A: 5 min horizon
rs5min = round(rbind(c(sprDecomp_5mn["RsprWmd_5mn","mid"],NA,NA,NA),
                     sprDecomp_5mn["RsprWmd_5mn",c("v", "NomBias", "t", "RelBias")],
                     sprDecomp_5mn["RsprMic_5mn",c("v", "NomBias", "t", "RelBias")]),3);
dimnames(rs5min) = list(c("Midpoint","Weighted midpoint", "Microprice"), c("Estimate", "Nominal bias", "t-stat", "Relative average bias"));

pi5min = round(rbind(c(sprDecomp_5mn["PimpWmd_5mn","mid"],NA,NA,NA),
                     sprDecomp_5mn["PimpWmd_5mn",c("v", "NomBias", "t", "RelBias")],
                     sprDecomp_5mn["PimpMic_5mn",c("v", "NomBias", "t", "RelBias")]),3);
dimnames(pi5min) = list(c("Midpoint","Weighted midpoint", "Microprice"), c("Estimate", "Nominal bias", "t-stat", "Relative average bias"));

capture.output(list(Realized_spread_5min = round(rs5min, 2), Price_impact_5min = round(pi5min, 2)) , file = "output/Table5a.txt");

# B: 10 sec horizon
rs10s = round(rbind(c(sprDecomp_10s["RsprWmd_10s","mid"],NA,NA,NA),
                     sprDecomp_10s["RsprWmd_10s",c("v", "NomBias", "t", "RelBias")],
                     sprDecomp_10s["RsprMic_10s",c("v", "NomBias", "t", "RelBias")]),3);
dimnames(rs10s) = list(c("Midpoint","Weighted midpoint", "Microprice"), c("Estimate", "Nominal bias", "t-stat", "Relative average bias"));

pi10s = round(rbind(c(sprDecomp_10s["PimpWmd_10s","mid"],NA,NA,NA),
                     sprDecomp_10s["PimpWmd_10s",c("v", "NomBias", "t", "RelBias")],
                     sprDecomp_10s["PimpMic_10s",c("v", "NomBias", "t", "RelBias")]),3);
dimnames(pi10s) = list(c("Midpoint","Weighted midpoint", "Microprice"), c("Estimate", "Nominal bias", "t-stat", "Relative average bias"));

capture.output(list(Realized_spread_10s = round(rs10s, 2), Price_impact_10s = round(pi10s, 2)) , file = "output/Table5b.txt");

# Clean-up
rm(sprDecomp_10s, sprDecomp_5mn, rs5min, rs10s, pi5min, pi10s);
