fakeData_function = function(ticker="A",P=40,S=0.1,D=10,TQ=0.1,nD=10000){
  # P = starting price in USD
  # S = minimum spread on each side in USD cents
  # D = number of trading days
  # TQ = fraction of observation being trades
  # nD = number of observations per day
  n = D*nD; # Total number of observations
  
  tq = data.table(v = P + cumsum(rnorm(n,0,sqrt(P)/10000)));
  tq$Bid.Price = trunc(100 * tq$v - S)/100; 
  tq$Ask.Price = (trunc(100* tq$v + S) + 1)/100;
  tq$mid       = (tq$Bid.Price + tq$Ask.Price)/2; # Midpoint
  tq$spr       = round(tq$Ask.Price - tq$Bid.Price,4); # Nominal spread. Important to not round to two digits for pre-decimalization sample
  tq$imb       = ((tq$v - tq$mid) / tq$spr) + 0.5;
  tq$Bid.Size  = round(tq$imb*100,0);
  tq$Ask.Size  = 100 - tq$Bid.Size;
  tq$Date      = rep(1:D,each=nD);
  tq$Stock     = ticker;
  tq[, Time := sort(sample(seq(9.5*3600, 16*3600, 0.1), nD, replace = F)), by = Date];
  
  # Generating trades
  tq$Type      = sample(c("Trade","Quote"), replace = T, size = n, prob = c(TQ,1-TQ));
  
  # Randomizing direction of trade to be related to order book imbalance
  #x = seq(-0.5, 0.5,0.01);
  #p = 1 / (1 + exp(-10*x));
  #plot(x, p, type = "l")
  
  #tq$p         = (2 * ((tq$imb-0.5) - sign(tq$imb-0.5) * ((tq$imb-0.5)^2)) / (100*tq$spr)) + 0.5; # Probability of buy trade
  tq$p         = 1 / (1 + exp(-10*(tq$imb-0.5))); # Probability of buy trade
  tq$D         = c(-1,1)[rbinom(n = n, size = 1, prob = tq$p) + 1];
  tq$D[tq$Type == "Quote"] = NA;
  
  # Setting prices equal to either bid or ask
  tq$Price     = NA;
  tq$Price[tq$D==+1 & tq$Type == "Trade"] = tq$Ask.Price[tq$D==+1 & tq$Type == "Trade"];
  tq$Price[tq$D==-1 & tq$Type == "Trade"] = tq$Bid.Price[tq$D==-1 & tq$Type == "Trade"];
  
  # Randomizing trade volumes
  tq$Volume = NA;
  tq$Volume[tq$Type == "Trade"] = sample(c(10,100,200,300,500,1000,5000,10000),sum(tq$Type == "Trade"), replace = T, prob = c(0.25,0.26,0.15,0.1,0.15,0.05,0.03,0.01));
  
  # Randomizing trading venues
  tq$Venue = NA;
  tq$Venue[tq$Type == "Trade"] = sample(c("a","b","c","d"),sum(tq$Type == "Trade"), replace = T);
  
  # Removing quote information for trades
  tq$Bid.Price[tq$Type == "Trade"] = NA;
  tq$Ask.Price[tq$Type == "Trade"] = NA;
  tq$Bid.Size[tq$Type == "Trade"]  = NA;
  tq$Ask.Size[tq$Type == "Trade"]  = NA;
  
  # Removing auxiliary variables
  tq[, c("mid","spr","imb","v","p","D") := NULL];
  
  # Reordering variables
  tq = tq[,c("Stock","Date","Time","Type","Price","Volume","Venue","Bid.Price","Bid.Size","Ask.Price","Ask.Size")];
  
  return(tq);
}
